﻿using System;
using System.Collections.Generic;
using System.Text;

namespace IndianHealthService.BMXNet.Services
{
    /// <summary>
    /// To test the BMXNetBroker class, we can use one instance of BMXNetBroker
    /// to be the authenicated transport and use the receiver to be the
    /// encapsulated BMX interaction.
    /// </summary>
    internal class BMXNetSessionConnectionOverAnotherSessionConnection : BMXNetSessionConnection
    {
        public static BMXNetSessionConnectionOverAnotherSessionConnection OpenOn(BMXNetBroker aBroker,BMXNetSessionConnection aConnection)
        {
            BMXNetSessionConnectionOverAnotherSessionConnection answer = new BMXNetSessionConnectionOverAnotherSessionConnection(aBroker);
            answer.SessionConnection = aConnection;
            return answer;
        }

        public BMXNetSessionConnectionOverAnotherSessionConnection(BMXNetBroker aBroker):base(aBroker) {

        }

        public override int ReceiveTimeout
        {
            get { return this.SessionConnection.ReceiveTimeout; }
            set { this.SessionConnection.ReceiveTimeout = value; }
        }

        public override int SendTimeout
        {
            get { return this.SessionConnection.SendTimeout; }
            set { this.SessionConnection.SendTimeout = value; }
        }

        public override Encoding ConnectionEncoding
        {
            get;
            set;
        }

        public override void Close()
        {
            this.SessionConnection.Close();
        }

        private BMXNetSessionConnection _sessionConnection = null;

        public BMXNetSessionConnection SessionConnection
        {
            get { return _sessionConnection; }
            set { _sessionConnection = value; }
        }

        protected override string SendReceiveString(string sendString, string multi)
        {
            return this.DecodeReceiveString(this.SessionConnection.TransmitRPC("CIABMX", this.EncodeSendString(sendString, multi)));
        }

        public override string GetLoginFacility(String aDuz)
        {
            return this.SessionConnection.GetLoginFacility(aDuz);
        }

        public override bool IsConnected
        {
            get
            {
                return this.SessionConnection.IsConnected;
            }
        }
    }
}
